<?php


class MakePdf
{
    public function create_pdf($file_name, $file_data)
    {

       $tmp_file_name = report_via_loc.$file_name . ".pdf";

        $pdf = new TCPDF(PDF_PAGE_ORIENTATION, PDF_UNIT, PDF_PAGE_FORMAT, true, 'UTF-8', false);

        //$pdf->setCreator(PDF_CREATOR);
        //$pdf->setAuthor('Nicola Asuni');
        $pdf->setTitle($file_name);
        // $pdf->setSubject('TCPDF Tutorial');
        //$pdf->setKeywords('TCPDF, PDF, example, test, guide');

        $pdf->setPrintHeader(false);
        $pdf->setPrintFooter(false);

        $pdf->setMargins(2, 5, 2);
        $pdf->setHeaderMargin(PDF_MARGIN_HEADER);
        $pdf->setFooterMargin(PDF_MARGIN_FOOTER);
        $pdf->setAutoPageBreak(TRUE, 0);
        $pdf->setImageScale(PDF_IMAGE_SCALE_RATIO);
        $pdf->AddPage();

        $html = <<<EOF
$file_data
EOF;

        $pdf->writeHTML($html, true, false, true, false, '');

        if (!file_put_contents($tmp_file_name, file_get_contents($pdf->Output('tmp', 'E')))) {
            return false;
        } else {
            return join("-",explode("/", $file_name)) . ".pdf";
        }
    }
}
