<?php

class NotPaidOrder
{
    private $db_con;

    public function __construct()
    {
        global $con;
        $this->db_con = $con;
    }

    public function not_paid_order_list($input_data)
    {
        $output_message = new OutputMessage();
        $item_details = new ItemDetails();
        $not_paid_order_list_data = [];

        if ($input_data->usr_paid_start_date != "" && $input_data->usr_paid_end_date != "") {
            $tmp_sql = "AND DATE(complete_date) between '" . $input_data->usr_paid_start_date . "' AND '" . $input_data->usr_paid_end_date . "' ";
        }else{
            $tmp_sql="";
        }



        $not_paid_sql = "SELECT " . tbl_profit . ".sub_vendor AS not_paid_sub_vendor, " . tbl_profit . ".complete_date AS not_paid_complete_date, " . tbl_profit . ".work_order_id AS not_paid_work_order_id, " . tbl_profit . ".address AS not_paid_address, " . tbl_profit . ".city AS not_paid_city, " . tbl_profit . ".zip_code AS not_paid_zip, " . tbl_profit . ".work_code AS not_paid_work_code, " . tbl_price_list . ".amount AS not_paid_amount FROM " . tbl_profit . " LEFT JOIN cltpr_price_list_tbl ON " . tbl_profit . ".work_code=" . tbl_price_list . ".work_code AND " . tbl_profit . ".zip_code=" . tbl_price_list . ".zip_code  WHERE " . tbl_profit . ".check_no='' AND " . tbl_profit . ".status='true' ".$tmp_sql." ORDER BY " . tbl_profit . ".complete_date DESC";
        $not_paid_query = mysqli_query($this->db_con, $not_paid_sql);
        while ($not_paid_arr = mysqli_fetch_assoc($not_paid_query)) {
            $tmp_name = "";
            $not_paid_inspector_sql = "SELECT first_name, last_name FROM " . tbl_usr . " WHERE alias LIKE '%" . $not_paid_arr["not_paid_sub_vendor"] . "%'";
            $not_paid_inspector_query = mysqli_query($this->db_con, $not_paid_inspector_sql);
            while ($not_paid_inspector_arr = mysqli_fetch_assoc($not_paid_inspector_query)) {
                $tmp_name = $not_paid_inspector_arr["first_name"] . " " . $not_paid_inspector_arr["last_name"];
            }

            if ($not_paid_arr["not_paid_amount"] == null) {
                $tmp_paid = number_format((float)filter_var(0, FILTER_VALIDATE_FLOAT), 2, '.', ',');
            } else {
                $tmp_paid = number_format((float)filter_var($not_paid_arr["not_paid_amount"], FILTER_VALIDATE_FLOAT), 2, '.', ',');
            }

            $tmp_data = [
                "inspector" => strtoupper($tmp_name),
                "inspector_pay" => "$ " . $tmp_paid,
                "work_order_id" => strtoupper($not_paid_arr["not_paid_work_order_id"]),
                "complete_date"=>date("m/d/Y", strtotime($not_paid_arr["not_paid_complete_date"])),
                "address" => strtoupper($not_paid_arr["not_paid_address"]). ', '. ucwords($not_paid_arr["not_paid_city"]),
                "zip_code" => strtoupper($not_paid_arr["not_paid_zip"]),
                "state" => $item_details->get_state_from_zip($not_paid_arr["not_paid_zip"]),
                "work_code" => strtoupper($not_paid_arr["not_paid_work_code"]),
            ];
            $not_paid_order_list_data[] = $tmp_data;
        }

        if (count($not_paid_order_list_data) > 0) {
            $api_output = $output_message->successOutput($not_paid_order_list_data, 'All not paid order(s) Loaded');
        } else {
            $api_output = $output_message->errorOutput('No not paid order available');
        }

        return $api_output;

    }


    public function download_not_paid_csv($input_data)
    {
        $output_message = new OutputMessage();
        $item_details = new ItemDetails();
        $not_paid_order_list_data = [];

        if ($input_data->usr_start_date != "" && $input_data->usr_end_date != "") {
            $tmp_sql = "AND DATE(complete_date) between '" . $input_data->usr_start_date . "' AND '" . $input_data->usr_end_date . "' ";
        }else{
            $tmp_sql="";
        }

        $not_paid_sql = "SELECT " . tbl_profit . ".sub_vendor AS not_paid_sub_vendor, " . tbl_profit . ".complete_date AS not_paid_complete_date, " . tbl_profit . ".work_order_id AS not_paid_work_order_id, " . tbl_profit . ".address AS not_paid_address, " . tbl_profit . ".zip_code AS not_paid_zip, " . tbl_profit . ".work_code AS not_paid_work_code, " . tbl_price_list . ".amount AS not_paid_amount FROM " . tbl_profit . " LEFT JOIN cltpr_price_list_tbl ON " . tbl_profit . ".work_code=" . tbl_price_list . ".work_code AND " . tbl_profit . ".zip_code=" . tbl_price_list . ".zip_code  WHERE " . tbl_profit . ".check_no='' AND " . tbl_profit . ".status='true' ".$tmp_sql." ORDER BY " . tbl_profit . ".complete_date DESC";
        
        $not_paid_query = mysqli_query($this->db_con, $not_paid_sql);
        while ($not_paid_arr = mysqli_fetch_assoc($not_paid_query)) {
            $tmp_name = "";
            $not_paid_inspector_sql = "SELECT first_name, last_name FROM " . tbl_usr . " WHERE alias LIKE '%" . $not_paid_arr["not_paid_sub_vendor"] . "%'";
            $not_paid_inspector_query = mysqli_query($this->db_con, $not_paid_inspector_sql);
            while ($not_paid_inspector_arr = mysqli_fetch_assoc($not_paid_inspector_query)) {
                $tmp_name = $not_paid_inspector_arr["first_name"] . " " . $not_paid_inspector_arr["last_name"];
            }

            if ($not_paid_arr["not_paid_amount"] == null) {
                $tmp_paid = number_format((float)filter_var(0, FILTER_VALIDATE_FLOAT), 2, '.', ',');
            } else {
                $tmp_paid = number_format((float)filter_var($not_paid_arr["not_paid_amount"], FILTER_VALIDATE_FLOAT), 2, '.', ',');
            }

            $tmp_data = [
                "inspector" => strtoupper($tmp_name),
                "inspector_pay" => "$ " . $tmp_paid,
                "completed_by" => strtoupper($not_paid_arr['not_paid_sub_vendor']),
                "work_order_id" => strtoupper($not_paid_arr["not_paid_work_order_id"]),
                "complete_date"=>date("m/d/Y", strtotime($not_paid_arr["not_paid_complete_date"])),
                "address" => strtoupper($not_paid_arr["not_paid_address"]),
                "zip_code" => strtoupper($not_paid_arr["not_paid_zip"]),
                "state" => $item_details->get_state_from_zip($not_paid_arr["not_paid_zip"]),
                "work_code" => strtoupper($not_paid_arr["not_paid_work_code"]),
            ];

            $not_paid_order_list_data[] = $tmp_data;
        }
        $file_name =  " not paid orders " . date('m/d/Y', strtotime($input_data->usr_start_date)) . " - " . date('m/d/Y', strtotime($input_data->usr_end_date));
        
        $file_name = "report-" . $input_data->usr_start_date . "-to-" . $input_data->usr_end_date;


        $report_file = $this->generate_not_paid_report_csv($file_name, $not_paid_order_list_data);
        if (!$report_file) {
            $api_output = $output_message->errorOutput("Report send ERROR");
        } else {
            $api_output = $output_message->successOutput(report_via_url_not_paid_csv . $report_file, "Report download successfully");
        }
        return $api_output;
    }


    
    

    //Generate CSV Report
    public function generate_not_paid_report_csv($file_name, $not_paid_order_list_data){
        
        
        $file = fopen(report_via_loc_not_paid__csv . $file_name . ".csv", 'w');
        $file_header = [
            "item_1" => "Inspector Price",
            "item_2" => "Completed By",
            "item_3" => "Completed",
            "item_4" => "Address",
            "item_5" => "Zip",
            "item_6" => "State",
            "item_7" => "Work Code"
        ];

        $report_arr = $not_paid_order_list_data;
        fputcsv($file, $file_header);
        foreach ($report_arr as $report_key => $report_val)
        {
            
            unset($report_val['inspector']);
            unset($report_val['work_order_id']);
            fputcsv( $file, array_values( $report_val ) );
        }
        
        if (fclose($file)) {
            return $file_name . ".csv";
        } else {
            return false;
        }
    }


    /*
        public function not_paid_order_list()
        {

            $output_message = new OutputMessage();
            $item_details = new ItemDetails();
            $beautify_arr = new ItemBeautify();
            $not_paid_order_list_data = [];

            $profit_data = $item_details->details_item_profit("status='true' AND check_no='' ORDER BY complete_date DESC");

            if (count($profit_data) > 0) {
                foreach ($profit_data as $single_profit) {
                    $tmp_inspector_data = $item_details->details_item_user("alias LIKE '%" . strtolower($single_profit["sub_vendor"]) . "%'");

                    if (count($tmp_inspector_data) > 0) {
                        foreach ($tmp_inspector_data as $single_inspector) {
                            $single_profit["inspector"] = $single_inspector["first_name"] . " " . $single_inspector["last_name"];
                        }
                    } else {
                        $single_profit["inspector"] = "";
                    }

                    $tmp_price_list_data = $item_details->details_item_price("work_code='" . strtolower($single_profit["work_code"]) . "' AND zip_code='" . $single_profit["zip_code"] . "'AND status='true'");

                    if (count($tmp_price_list_data) > 0) {
                        foreach ($tmp_price_list_data as $single_price) {
                            $single_profit["inspector_pay"] = number_format((float)filter_var($single_price["amount"], FILTER_VALIDATE_FLOAT), 2, '.', ',');
                        }
                    } else {
                        $single_profit["inspector_pay"] = number_format((float)filter_var(0, FILTER_VALIDATE_FLOAT), 2, '.', ',');
                    }


                    $single_profit = $beautify_arr->beautify($single_profit, ["id", "check_no", "expected_amount", "actual_amount", "main_vendor", "sub_vendor",  "state", "city", "zone", "order_date", "reassigned_date", "complete_date", "due_date", "billed_date", "check_date", "status", "date_time"]);
                    $not_paid_order_list_data[] = $single_profit;
                }
                $api_output = $output_message->successOutput($not_paid_order_list_data, 'All not paid order(s) Loaded');
            } else {
                $api_output = $output_message->errorOutput('No not paid order available');
            }

            return $api_output;
        }
    */
}






