<?php
// error_reporting(E_ALL);
// ini_set('display_errors', '1');
class PriceList
{
    private $db_con;
    public function __construct()
    {
        global $con;
        $this->db_con = $con;
    }

    public function price_list(): array
    {
        $output_message = new OutputMessage();
        $item_details = new ItemDetails();
        $beautify_arr = new ItemBeautify();
        $price_data = [];

        $tmp_price_data = $item_details->details_item_price("status='true' ORDER BY id DESC");

        if (count($tmp_price_data) > 0) {
            foreach ($tmp_price_data as $single_price) {
                //echo "<pre>"; print_r($single_price); echo "</pre>";
                $single_price = $beautify_arr->beautify($single_price, ["status", "date_time"]);
                $price_data[] = $single_price;
            }
            $api_output = $output_message->successOutput($price_data, 'All price(s) Loaded');
        } else {
            $api_output = $output_message->errorOutput('No price available');
        }

        return $api_output;
    }

    public function price_details($input_data): array
    {
        $item_details = new ItemDetails();
        $output_message = new OutputMessage();
        $beautify_arr = new ItemBeautify();

        $price_list_data = [];

        $price_list_details_data = $item_details->details_item_price("uid='$input_data->price_id' AND status='true'");

        if (count($price_list_details_data) > 0) {
            foreach ($price_list_details_data as $single_price_list) {
                $single_price_list = $beautify_arr->beautify($single_price_list, ["id", "status", "reset_status", "date_time"]);

                $price_list_data = $single_price_list;
            }
            $api_output = $output_message->successOutput($price_list_data, "price details loaded successfully");
        } else {
            $api_output = $output_message->errorOutput("price DETAILS ERROR");
        }

        return $api_output;
    }

    public function price_manage($manage_type, $input_data): array
    {
        $item_manage = new ItemManage();
        $output_message = new OutputMessage();

        $price_request_data = $item_manage->manage_item_price($manage_type, $input_data);

        if ($price_request_data) {
            $api_output = $output_message->successOutput("", "price " . join(" ", explode("-", $manage_type)) . " successfully");
        } else {
            $api_output = $output_message->errorOutput("price " . join(" ", explode("-", $manage_type)) . " ERROR");
        }

        return $api_output;
    }

    public function price_upload($input_data): array
    {
        $item_manage = new ItemManage();
        $output_message = new OutputMessage();


        if ($item_manage->manage_item_csv($input_data->usr_file_data, 4, "price_list")) {
            $api_output = $output_message->successOutput("", 'File uploaded successfully');
        } else {
            $api_output = $output_message->errorOutput('File upload error!!!');
        }


        return $api_output;
    }

    //Download price list csv

    public function download_price_list_csv($input_data){
        $output_message = new OutputMessage();
        $item_details = new ItemDetails();
        $beautify_arr = new ItemBeautify();

        $price_data = [];

        $tmp_price_data = $item_details->details_item_price("status='true' ORDER BY id DESC");
        
        if (count($tmp_price_data) > 0) {
            foreach ($tmp_price_data as $single_price) {
                $single_price = $beautify_arr->beautify($single_price, ["status", "date_time"]);
                $price_data[] = $single_price;
            }
        $file_name = "report-price-list-".date("m-d-Y");

        $report_file = $this->generate_price_list_csv($file_name, $price_data);
        if (!$report_file) {
            $api_output = $output_message->errorOutput("Report send ERROR");
        } else {
            $api_output = $output_message->successOutput(report_via_url_price_list_csv . $report_file, "Report download successfully");
        }

        } else {
            $api_output = $output_message->errorOutput('No price available');
        }

        return $api_output;
    }




    //Erase/Delete price list

    public function erase_price_list($input_data){
        $item_manage = new ItemManage();
        $output_message = new OutputMessage();
        // echo "<pre>"; print_r($input_data); echo "</pre>"; die;
        if($input_data->user_resp && $input_data->user_resp === "delete me"){
            $erase_price_list = $item_manage->erase_pricelist_pricing($input_data);
            if ($erase_price_list) {
                $api_output = $output_message->successOutput("", 'Price list erased successfully!');
            } else {
                $api_output = $output_message->errorOutput("ERROR");
            }    
        }else{
            $api_output = $output_message->errorOutput("ERROR");
        }
        return $api_output;
    }


    function generate_price_list_csv($file_name, $price_list_data){
        //echo "<pre>"; print_r($price_list_data); echo "</pre>"; die;
        $file = fopen(report_via_loc_price_list_csv . $file_name . ".csv", 'w');
        $file_header = [
            "item_1" => "Amount",
            "item_2" => "State",
            "item_3" => "Work Code",
            "item_4" => "Zip"
        ];

        $report_arr = $price_list_data;
        fputcsv($file, $file_header);
        foreach ($report_arr as $report_key => $report_val)
        {
            unset($report_val['id']);
            fputcsv( $file, array_values( $report_val ) );
        }
        
        if (fclose($file)) {
            return $file_name . ".csv";
        } else {
            return false;
        }
    }

    function price_list_manage_bulk($input_data){
        $output_message = new OutputMessage();
        $tmp_count = 0;

        $tmp_price_list_id_arr = explode(",", $input_data->usr_price_list_id);
        $tmp_price_list_amount_arr = explode(",", $input_data->usr_price_list_amount);
        $tmp_data = new stdClass();

        for ($i = 0; $i < sizeof($tmp_price_list_id_arr); $i++) {
            $tmp_data->usr_price_list_id = $tmp_price_list_id_arr[$i];
            $tmp_data->usr_price_list_amount = $tmp_price_list_amount_arr[$i];
            $tmp_update_status = $this->price_list_manage_single($tmp_data);
            if ($tmp_update_status) {
                $tmp_count++;
            }
        }

        if ($tmp_count == sizeof($tmp_price_list_id_arr)) {
            $api_output = $output_message->successOutput("", 'Price list updated successfully');
        } else {
            $api_output = $output_message->errorOutput('Price list update Error');
        }

        return $api_output;
    }


    private function price_list_manage_single($input_data)
    {
        if($input_data->usr_price_list_amount && $input_data->usr_price_list_id){
            $price_list_bulk_sql = /** @lang text */
            "UPDATE " . tbl_price_list . " SET amount='" . $input_data->usr_price_list_amount . "' WHERE ";
            $price_list_bulk_sql .= /** @lang text */
            "uid='" . $input_data->usr_price_list_id . "'";
            if(mysqli_query($this->db_con, $price_list_bulk_sql)){
                return true;
            }else{
                return false;
            }
            
        }else{
            return false;
        }
        
    }

}
