<?php

class SimpleList
{
    public function __construct()
    {
    }

    public function simple_user_list(): array
    {
        $output_message = new OutputMessage();
        $item_details = new ItemDetails();
        $beautify_arr = new ItemBeautify();

        $usr_data = [];

        $condition = "(usr_type='agent' OR usr_type='inspector') AND status='true' ORDER BY first_name ASC";

        $tmp_user_data = $item_details->details_item_user($condition);

       // $tmp_user_data = $item_details->details_item_user("status='true' AND verification_status='true' AND (usr_type='inspector' OR usr_type='agent') ORDER BY first_name ASC");

        if (count($tmp_user_data) > 0) {
            foreach ($tmp_user_data as $single_user) {
                $single_user = $beautify_arr->beautify($single_user, ["authorize_token", "user_img", "mail", "alias", "password", "reset_code", "reset_time", "type", "access_level", "verification_code", "reset_status", "verification_status", "status", "date_time"]);
                $usr_data[] = $single_user;
            }
            $api_output = $output_message->successOutput($usr_data, 'All User(s) Loaded');
        } else {
            $api_output = $output_message->errorOutput('No User available');
        }


        return $api_output;
    }

    public function simple_inspector_list(): array
    {
        $output_message = new OutputMessage();
        $item_details = new ItemDetails();
        $beautify_arr = new ItemBeautify();

        $usr_data = [];

        $tmp_user_data = $item_details->details_item_user("status='true' AND verification_status='true' AND usr_type='inspector' ORDER BY first_name ASC");

        if (count($tmp_user_data) > 0) {
            foreach ($tmp_user_data as $single_user) {
                $single_user = $beautify_arr->beautify($single_user, ["authorize_token", "user_img", "mail", "alias", "password", "reset_code", "reset_time", "type", "access_level", "verification_code", "reset_status", "verification_status", "status", "date_time"]);
                $usr_data[] = $single_user;
            }
            $api_output = $output_message->successOutput($usr_data, 'All User(s) Loaded');
        } else {
            $api_output = $output_message->errorOutput('No User available');
        }


        return $api_output;
    }

    public function simple_work_code_list(): array
    {
        $output_message = new OutputMessage();
        $item_details = new ItemDetails();
        $beautify_arr = new ItemBeautify();

        $work_code_data = [];


        $tmp_work_code_data = $item_details->details_item_price("status='true' ORDER BY work_code ASC");

        if (count($tmp_work_code_data) > 0) {
            foreach ($tmp_work_code_data as $single_work_code) {
                $single_work_code["label"] = $single_work_code["work_code"];
                $single_work_code = $beautify_arr->beautify($single_work_code, ["id", "work_code", "amount", "zip_code", "status", "date_time"]);
                $single_work_code["id"] = strtolower($single_work_code["label"]);
                $work_code_data[] = $single_work_code;
            }
            $api_output = $output_message->successOutput($this->unique_array_filter($work_code_data), 'All work code(s) Loaded');
        } else {
            $api_output = $output_message->errorOutput('No work code available');
        }

        return $api_output;
    }

    public function simple_zip_list(): array
    {
        $output_message = new OutputMessage();
        $item_details = new ItemDetails();
        $beautify_arr = new ItemBeautify();

        $work_code_data = [];


        $tmp_work_code_data = $item_details->details_item_price("status='true' ORDER BY zip_code ASC");

        if (count($tmp_work_code_data) > 0) {
            foreach ($tmp_work_code_data as $single_work_code) {
                $single_work_code["label"] = $single_work_code["zip_code"];
                $single_work_code = $beautify_arr->beautify($single_work_code, ["id", "work_code", "amount", "zip_code", "status", "date_time"]);
                $single_work_code["id"] = strtolower($single_work_code["label"]);
                $work_code_data[] = $single_work_code;
            }
            $api_output = $output_message->successOutput($this->unique_array_filter($work_code_data), 'All work code(s) Loaded');
        } else {
            $api_output = $output_message->errorOutput('No work code available');
        }

        return $api_output;
    }


    private function unique_array_filter($multi_array): array
    {
        $unique_array = array();
        foreach ($multi_array as $sub_array) {
            if (!in_array($sub_array, $unique_array)) {
                $unique_array[] = $sub_array;
            }
        }
        return $unique_array;
    }
}